@echo off

pushd "%~dp0"
SET OPT=
IF /I "%1"=="/s" (
    IF NOT "%2"=="" (
        SET OPT=%2
    )
)
SET PACKAGE=
SET LICENSE=
SET PACKAGE_MASK=*.msixbundle
SET LICENSE_MASK=*.xml
FOR %%F IN (%PACKAGE_MASK%) DO (
    SET PACKAGE=%%~fF
)
FOR %%F IN (%LICENSE_MASK%) DO (
    SET LICENSE=%%~fF
)

IF "%OPT%"=="" (
    @echo ===========================================================================
    @echo Complete Anatomy Offline Installer
    @echo ===========================================================================
    @echo.
    @echo Installation options:
    @echo   /s ^<option^>  - Silent mode with option number ^(1-4^)
    @echo.
    @echo 1. Install package for current user
    @echo 2. Uninstall package for current user
    @echo 3. Install package via DISM
    @echo 4. Uninstall package via DISM
    @echo.
    CHOICE /C 1234 /N /M "Please choose from one of the above options (type 1, 2, 3 or 4):"
    IF ERRORLEVEL 1 SET OPT=1
    IF ERRORLEVEL 2 SET OPT=2
    IF ERRORLEVEL 3 SET OPT=3
    IF ERRORLEVEL 4 SET OPT=4
    @echo.
)

REM Validate option
IF NOT "%OPT%"=="" (
    IF NOT "%OPT%"=="1" IF NOT "%OPT%"=="2" IF NOT "%OPT%"=="3" IF NOT "%OPT%"=="4" (
        @echo Error: Invalid option '%OPT%'. Please use 1, 2, 3, or 4.
        exit /b 1
    )
)

SET COMMAND=
IF "%OPT%"=="1" SET COMMAND=install
IF "%OPT%"=="2" SET COMMAND=uninstall
IF "%OPT%"=="3" SET COMMAND=install_dism
IF "%OPT%"=="4" SET COMMAND=uninstall_dism

@echo ===========================================================================
@echo Running offline %COMMAND%, this could take a few minutes. Please wait.
@echo ===========================================================================
@echo off
powershell.exe -executionpolicy bypass -command "& { . ./install.ps1; %COMMAND% %PACKAGE% %LICENSE% }"
@echo.
@echo Complete Anatomy %COMMAND% process finished.
exit /b 0
